<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Monolog\Formatter\JsonFormatter;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use Propaganistas\LaravelPhone\PhoneNumber;
use Symfony\Component\HttpFoundation\StreamedResponse;
use YoHang88\LetterAvatar\LetterAvatar;

class SystemController extends Controller
{
    /**
     * instance of controller
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * returns the elapsed time
     * @param $time
     * @return string
     */
    public static function elapsedTime($time): string
    {
        return Carbon::parse($time)->diffForHumans();
    }

    /**
     * Write the system log files
     * @param array $data
     * @param string $channel
     * @param string $fileName
     */
    public static function log(array $data, string $channel, string $fileName)
    {
        $file = storage_path('logs/' . $fileName . '.log');

        // finally, create a formatter
        $formatter = new JsonFormatter();

        // Create the log data
        $log = [
            'ip' => request()->getClientIp(),
            'data' => $data,
        ];
        // Create a handler
        $stream = new StreamHandler($file, Logger::INFO);
        $stream->setFormatter($formatter);

        // bind it to a logger object
        $securityLogger = new Logger($channel);
        $securityLogger->pushHandler($stream);
        $securityLogger->log('info', $channel, $log);
    }

    /**
     * get greetings here
     * @return string
     */
    public static function pass_greetings_to_user(): string
    {
        $message = 'Hello';

        if (date("H") < 12) {
            $message = "Good Morning";
        } elseif (date("H") >= 12 && date("H") < 16) {
            $message = "Good Afternoon";
        } elseif (date("H") >= 16) {
            $message = "Good Evening";
        }

        return $message;
    }

    /**
     * generate avatars here
     * @param string $name
     * @param int $size
     * @return LetterAvatar
     */
    public static function generateAvatars(string $name, int $size): LetterAvatar
    {
        return new LetterAvatar($name, 'circle', $size);
    }

    /**
     * store image here
     * @param $file_request
     * @param string $path
     * @return array
     */
    public static function store_media($file_request, string $path = 'stack'): array
    {
        // check if feature_image exists
        if (isset($file_request)) {
            // generate new name for image
            $original_file_name = $file_request->getClientOriginalName();
            $newFileName = $original_file_name. '.' . $file_request->extension();
            // store the new image
            $file_request->storePubliclyAs($path, $newFileName, 'do_space');
            // assign variables
            $url = Storage::disk('do_space')->url($path . '/' . $newFileName);
            $size = Storage::disk('do_space')->size($path . '/' . $newFileName);

            return [
                $newFileName, // this will be the new file name i.e logo.png
                $url, // set the path for loading the image i.e http:IP/storage/logo.png
                $size // get file size in bytes
            ];
        }
        return [null, '#', 0];
    }

    // public static function store_media($file_requests, string $path = 'stack'): array
    // {
    //     $results = [];
    
    //     foreach ($file_requests as $file_request) {
    //         // check if file exists and is valid
    //         if ($file_request && $file_request->isValid()) {
    //             // generate new name for file
    //             $original_file_name = $file_request->getClientOriginalName();
    //             $newFileName = $original_file_name . '.' . $file_request->extension();
    //             // store the new file
    //             $file_request->storePubliclyAs($path, $newFileName, 'do_space');
    //             // assign variables
    //             $url = Storage::disk('do_space')->url($path . '/' . $newFileName);
    //             $size = Storage::disk('do_space')->size($path . '/' . $newFileName);
    
    //             // add file details to results array
    //             $results[] = [
    //                 'filename' => $newFileName,
    //                 'url' => $url,
    //                 'size' => $size
    //             ];
    //         }
    //     }
    
    //     return $results;
    // }
    

    /**
     * unlink media here
     * @param string|null $fileName
     * @param string $path
     */
    public static function un_link_media(string|null $fileName, string $path = 'stack')
    {
        // check if image exists
        if (Storage::disk('do_space')->exists($path . '/' . $fileName)) {
            // unlink the media here after upload
            Storage::disk('do_space')->delete($path . '/' . $fileName);
        }
    }

    /**
     * Download the files
     * @param string $fileName
     * @param string $path
     * @return StreamedResponse
     */
    public static function downloadMedia(string $fileName, string $path = 'stack'): StreamedResponse
    {
        return Storage::disk('public')->download($path . '/' . $fileName);
    }

    /**
     * format phone number
     * @param string $phoneNumber
     * @param string $short2Code
     * @return string
     */
    public static function format_phone_number(string $phoneNumber, string $short2Code): string
    {
        return PhoneNumber::make($phoneNumber)->ofCountry($short2Code);
    }

    /**
     * validate the phone number with country
     * @param string $phoneNumber
     * @param string $short2Code
     * @return bool
     */
    public static function validate_phone_number(string $phoneNumber, string $short2Code): bool
    {
        try {
            return PhoneNumber::make($phoneNumber, $short2Code)->isOfCountry($short2Code);
        } catch (Exception $exception) {
            Log::error($exception->getMessage());
            return false;
        }
    }

}
