<?php

namespace App\Http\Livewire\Admin\Classes;

use App\Models\Classroom;
use App\Models\Project;
use App\Models\User;
use App\Models\Exam;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;


class ListClassUpdateStudents extends Component
{
    // Disable lazy loading for this component
    protected $lazy = false;
    use FindGuard, LivewireAlert;
    use WithPagination;

    public $search;
    public $model, $project, $name, $classroom1,$classstatus,$year_edu,$year;
    protected $queryString = ['search'];
    public $studentid  = [];
    

    protected string $paginationTheme = 'bootstrap';

    /*public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData1()
    {
        $this->readyToLoad = true;
    }*/
    protected $rules = [
        'year_edu' => 'required',
        //'email' => 'required|email',
    ];
    public function mount($slug)
    {
        $this->model = Classroom::query()->where('slug', $slug)->first();
        $this->name = $this->model->name;
    }
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }
    public function updateStudent(){
        $validatedData = $this->validate();
        //echo "asd";
        //print_r($this->$studentid);
        //echo $this->classroom1;
        //dd($this->studentid,$this->classroom1,$this->year_edu);



        foreach($this->studentid as $student){
            //echo $student;
            User::where("id",$student)->update(["classroom_id"=>$this->classroom1,"year_edu"=>$this->year_edu]);


        }
         $this->alert('success', 'Record updated successfully!');





    }

    public function render()
{
    if(!empty($this->year)  ){
        $users = Exam::where("trimester_id","1")->where("year",$this->year)->where("classroom_id",$this->model->id)->distinct()->pluck('student_id');
        $userss = array();
        foreach($users as $user){
            $userss[] = $user;
        }
        return view('livewire.admin.classes.list-class-update-students', [
            'models' =>  User::query()
                    ->where(function ($query) {
                        $query->orWhere('name', 'like', '%' . $this->search . '%')
                            ->orWhere('sex', 'like', '%' . $this->search . '%')
                            ->orWhere('phone_number', 'like', '%' . $this->search . '%')
                            ->orWhere('slug', 'like', '%' . $this->search . '%');
                    })
                    ->whereIn('id', $userss)
                    //->where('year_edu', '<>' , date('Y') )
                    ->orderBy('name') // Order by the 'name' column alphabetically
                    ->paginate(60),

                    "classroom" => Classroom::orderBy("class")->get(),
                    
                
        ]);
    }else{
        return view('livewire.admin.classes.list-class-update-students', [
            'models' =>  User::query()
                    ->where(function ($query) {
                        $query->orWhere('name', 'like', '%' . $this->search . '%')
                            ->orWhere('sex', 'like', '%' . $this->search . '%')
                            ->orWhere('phone_number', 'like', '%' . $this->search . '%')
                            ->orWhere('slug', 'like', '%' . $this->search . '%');
                    })
                    ->where('classroom_id', $this->model->id)
                    //->where('year_edu', '<>' , date('Y') )
                    ->orderBy('name') // Order by the 'name' column alphabetically
                    ->paginate(60),

                    "classroom" => Classroom::orderBy("class")->get(),
                    
                
        ]);

    }
}

}
