<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                        <h5 class="card-title"> Estudantes da: <?php echo e($model->class); ?> classe / <?php echo e($model->name); ?></h5>
                            <div class="row">
                                <div class="col-md-9">
                                    <input type="search" wire:model="search" placeholder="Pesquisar..."
                                           class="form-control">
                                </div>
                                <div class="col-md-3">
                                    <select class="form-select" wire:model="year">
                                        <option >Selecione o Ano</option>
                                        <option value="2023">2023</option>
                                       
                                    </select>
                                </div>
                            </div>
                            <div class="table-responsive" wire:init="loadData">
                                <?php if(count($models)): ?>
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Nome</th>
                                            <th scope="col">Sexo</th>
                                            <th scope="col">Data de Nascimento</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">ID do Estudante</th>
                                            <th scope="col">Turma</th>
                                            <th scope="col">Classe</th>
                                            <th scope="col">Data/Hora</th>
                                            
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php ($count = 1); ?>
                                        <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>

                                                <th scope="row"><?php echo e($count++); ?></th>
                                                <td><?php echo e($model->name); ?></td>
                                                <td><?php echo e($model->sex); ?></td>
                                                <td><?php echo e($model->dob); ?></td>
                                                <td><?php echo e($model->email); ?></td>
                                                <td><?php echo e($model->student_id); ?></td>
                                                <td><?php echo e($model->class->name); ?></td>
                                                <td><?php echo e($model->class->class); ?> &nbsp;&nbsp; Classe</td>
                                                <td><?php echo e(date('F d, Y h:i a', strtotime($model->created_at))); ?></td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    <div class="row float-end">
                                        <?php echo e($models->links()); ?>

                                    </div>
                                <?php else: ?>
                                    <br>
                                    <br>
                                    <div  class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<?php /**PATH /home/1165120.cloudwaysapps.com/ttmjqktapb/public_html/resources/views/livewire/admin/classes/list-class-students.blade.php ENDPATH**/ ?>